;; v_cmd.lsp file 
;; Keyboard command names and calls
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; DIMENSIONS ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; DIM STYLE ;;;; 
(defun c:dsm ()        
  (load "v_dset")      
  (v_dset)             
  (setq v_dset nil)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; DIME MOVE ;;;;;
(defun c:dm ()         
  (if (= nil v_dimv)   
    (load "v_dimv")
  )
  (v_dimv)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; DIM CENTER ;;;
(defun c:dc ()         
  (if (= nil v_dimc)   
    (load "V_DIMC")    
  )                          
  (v_dimc)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:db ()               ;; Changes arrow block 
  (if (= nil v_dimr)         ;; to currently defined
    (load "V_DIMR")       
  )                        
  (v_dimr)                   
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; DISPLAY/UCS ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; UCS ;;;;;;;;;
(defun c:uu ()                
  (if (= nil v_ucs)
    (load "v_ucs")
  )
  (v_ucs "ucs")
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; VIEW STEP ;;;;
(defun c:v ()           
  (if (and (= (getvar "TILEMODE") 0)
           (= (getvar "CVPORT") 1))
    (prompt "\nActivate MODEL SPACE for the ViewStep command")
    (progn
      (if (= nil v_vwpt)(load "v_vwpt"))
      (v_vwpt nil)
    )
  )
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; PLAN VIEW ;;;;
(defun c:pv ()               ;; creates and/or 
  (shtvw)                    ;; restores preset view
  (princ)               
)                  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; DRAW OBJECTS ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; BREAK LINE ;;;
(defun c:bk ()               
  (if (= nil v_bkln)         
    (load "V_BKLN")          
  )
  (v_bkln)
  (princ)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; FRAM PLN OBJ 
(defun c:r ()                ;; draws structural plan
  (if (= nil v_frame)(progn  ;; symbols (w/ submenu)
    (prompt "\nLoading file ...")
    (load "v_frame")
    (v_set6)
  ))
  (v_frame)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; FRAMES/PANELS 
(defun c:fp ()               ;; draws elevations
  (if (= nil v_fpan)(progn   ;; of windows/doors/etc
    (princ "\nLoading ...")
    (load "v_fpan")
    (v_set4)
  ))
  (v_fpan)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; LEADER ;;;;;;;
(defun c:dr ()               ;; draw leader w/ arch
  (if (= nil v_leader)       ;; style arrow and 
    (load "v_leader")        ;; text
  )
  (v_leader)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; X-DRAW ;;;;;;;
(defun c:xx ()               
  (if (= nil v_XDRAW)        
    (load "V_XDRAW")         
  )
  (v_xdraw)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; PFACE ;;;;;;;;
(defun c:pm ()
  (if (= nil v_pface)
    (load "v_pface")
  )
  (v_pface)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; RECTANGLE ;;;;
(defun c:rec ()              
  (if (= nil rect)           
    (load "v_lined")
  )
  (rect)   
  (princ) 
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; CUSTOM OBJECTS
(defun c:co ()
  (if (= nil v_obj)
    (load "v_obj")
  )
  (v_obj)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; LINE DRAW ;;;;
(defun c:d1 ()              
  (if (= nil dlin1)          
    (load "v_lined")
  )
  (dlin1) 
  (princ) 
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:d2 ()               
  (if (= nil dlin2)          
    (load "v_lined")
  )
  (dlin2)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:d3 ()              
  (if (= nil dlin3)         
    (load "v_lined")
  )
  (dlin3) 
  (princ)  
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:d4 ()              
  (if (= nil dlin4)         
    (load "v_lined")
  )
  (dlin4) 
  (princ) 
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:f1 ()              
  (if (= nil v_auxln)
    (load "v_lined")
  )
  (v_set2)
  (v_auxln "f1")
  (princ)                    
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:f2 ()              
  (if (= nil v_auxln)
    (load "v_lined")
  )
  (v_set2)
  (v_auxln "f2")  
  (princ)                    
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:f3 ()              
  (if (= nil v_auxln)
    (load "v_lined")
  )
  (v_set2)
  (v_auxln "f3")  
  (princ)                   
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:f4 ()              
  (if (= nil v_auxln)
    (load "v_lined")
  )
  (v_set2)
  (v_auxln "f4")  
  (princ)                    
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:g1 ()              
  (if (= nil v_auxln)
    (load "v_lined")
  )
  (v_set2)
  (v_auxln "g1")  
  (princ)           
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:g2 ()              
  (if (= nil v_auxln)
    (load "v_lined")
  )
  (v_set2)
  (v_auxln "g2")  
  (princ)            
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:g3 ()              
  (if (= nil v_auxln)
    (load "v_lined")
  )
  (v_set2)
  (v_auxln "g3")  
  (princ)               
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:g4 ()              
  (if (= nil v_auxln)
    (load "v_lined")
  )
  (v_set2)
  (v_auxln "g4")  
  (princ)           
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; EDITING ;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; EDIT EVERY ;;;
(defun c:ee ()            
  (if (= nil v_eat) (progn
    (prompt "\nLoading lisp file ...")
    (load "v_eat")
  ))
  (v_eat)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; SUBSTITUTES
(defun c:c ()                ;; copy
  (if (= nil v_c)
    (load "v_edcoms")
  )
  (v_c)
  (princ)
)
(defun c:m ()                ;; move
  (if (= nil v_c)
    (load "v_edcoms")
  )
  (v_m)
  (princ)
)
(defun c:e ()                ;; erase
  (if (= nil v_c)
    (load "v_edcoms")
  )
  (v_e)
  (princ)
)
(defun c:x ()                ;; extend
  (if (= nil v_c)
    (load "v_edcoms")
  )
  (v_x)
  (princ)
)
(defun c:t ()                ;; trim
  (if (= nil v_c)
    (load "v_edcoms")
  )
  (v_t)
  (princ)
)
(defun c:o ()                ;; offset
  (if (= nil v_c)
    (load "v_edcoms")
  )
  (v_o)
  (princ)
)
(defun c:f ()                ;; fillet
  (if (= nil v_c)
    (load "v_edcoms")
  )
  (setq flag nil)
  (v_f)
  (princ)
)
(defun c:ff ()               ;; multi-fillet
  (if (= nil v_c)
    (load "v_edcoms")
  )
  (v_ff)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; HATCH ;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; PLYWD FILL ;;;
(defun c:pf ()       
  (if (= nil v_PFILL)
    (load "V_PFILL") 
  )                  
  (v_pfill)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; WALL FILL ;;;;
(defun c:wf ()        
  (if (= nil v_poche)(progn 
    (load "v_poche")  
    (v_set7)
  ))                   
  (v_poche)           
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; LAYERS ;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; GROUP MOVE/COPY
(defun c:yg ()  
  (if (= nil v_lgrp) (progn
    (prompt "\nLoading lisp file ...")
    (load "v_lgrp")
  ))
  (v_lgrp)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; GROUP DISPLAY 
(defun c:gs ()               ;; SDSK only
  (if (/= "t" g_lck)
    (princ "\nChecking for SDSK layer groups not active")
    (v_st "s") 
  )
  (princ)    
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; GROUP SET ;;;;
(defun c:gss ()              ;; SDSK only
  (if (/= "t" g_lck)
    (princ "\nChecking for SDSK layer groups not active")
    (v_st "g") 
  )
  (princ)                
)                       
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; LAYER WHAT ;;;
(defun c:yw ()   
  (if (= nil lwhat)
    (load "v_laym")
  )
  (lwhat)                    
  (princ)                    
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; LAYER SET ;;;;
(defun c:yy ()    
  (if (= nil laypic)
    (load "v_laym")
  )
  (laypic)                   
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; LAYER OFF ;;;;
(defun c:yo ()            
  (if (= nil layfff)      
    (load "v_laym")
  )
  (layfff "o")  
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; LAYER FREEZE ;;
(defun c:yf ()     
  (if (= nil layfff)
    (load "v_laym")
  )
  (layfff "f") 
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; LAYER EXPORT 
(defun c:yx ()       
  (if (= nil lwrt)           ;; Writes current layer
    (load "v_lsnap")         ;; setting to file for
  )                          ;; use with "Layer Toggle"
  (setq g_inlay nil)         ;; command.  Overwrites
  (lwrt)                     ;; same file each time
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; LAYER TOGGLE
(defun c:yt ()       
  (if (= nil lwrt)(progn     ;; Restore layer settings
    (prompt (strcat          ;; written to file with
    "\nYou must use Layer-xport"  
    " command first ...")))  ;; the Layer-export 
    (progn                   ;; command
    (setq g_inlay nil)       
    (lred))  
  )
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; MULTISCALE ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; DETAIL DRAW ;;
(defun c:dd ()               ;; Block (detail) editor
  (if (= nil v_det)          ;; explodes, scales, zooms,
    (load "v_det")
  )
  (v_det)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; DETAIL TITLE BLOCK
(defun c:dt ()               ;; Block (detail) editor
  (if (= nil v_detbrd)          ;; explodes, scales, zooms,
    (load "v_detbrd")
  )
  (v_detbrd)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; REF OBJECTS ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; DETAIL SYMBOL 
(defun c:dq ()
  (if (= nil v_mark)(progn
    (princ "\nLoading file ...")
    (load "v_mark")
    (v_set3)
  ))
  (v_mark "d")
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; SECTION SYMBOL 
(defun c:sq ()  
  (if (= nil v_mark)(progn
    (princ "\nLoading file ...")
    (load "v_mark")   
    (v_set3)
  ))    
  (v_mark "s")
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; BUBBLE REF ;;;
(defun c:bb ()                
  (if (= nil v_bubref)(progn
    (load "v_bubref")
    (v_set3)
  ))
  (v_bubref)
  (princ)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; TEXT ;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; TX UTIL ;;;;;;
(defun c:tu ()        
  (if (= nil txer) (progn
    (prompt "\nLoading lisp file ...")
    (load "v_txut")
  ))
  (v_txut)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; IMPORT TXT FILE
(defun c:it ()        
  (if (= nil v_txtin)
    (load "v_txtin")
  )
  (setq v_acii "S")
  (v_imptx)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; NOTE ;;;;;;;;;
(defun c:n ()     
  (if (= nil v_note)
    (load "v_note") 
  )                 
  (v_note "n")          
  (princ)               
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; NOTE SMALL ;;;
(defun c:ns ()       
  (if (= nil v_note) 
    (load "v_note")
  )
  (v_note "s")               
  (princ)                  
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; DWG TITLE ;;;;
(defun c:tit ()         
  (if (= nil v_tit)(progn
    (load "v_tit")      
    (v_set5)
  ))                     
  (v_tit)               
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; FORM FILL ;;;;
(defun c:tf ()      
  (if (= nil v_txff)
    (load "v_txff")
  )
  (v_txff)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; MATCH TEXT ;;;
(defun c:xt ()      
  (if (= nil v_mattxt)
    (load "v_mattxt")
  )
  (v_mattxt)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; STYLE SET ;;;;
(defun c:sset ()             ;; reset style fonts
  (if (= nil v_stset)        ;; (fast or presention)
    (load "v_stset")         ;; from list in v_fonts.lsp
  )                          ;; program file
  (v_stset)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; GEN TEXT ;;;;;
(defun c:t1 ()      
  (if (= nil v_text)
    (load "v_text")
  )
  (v_text "t" 1)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:t2 ()
  (if (= nil v_text)
    (load "v_text")
  )
  (v_text "t" 2)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:t3 ()
  (if (= nil v_text)
    (load "v_text")
  )
  (v_text "t" 3)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:t4 ()
  (if (= nil v_text)
    (load "v_text")
  )
  (v_text "t" 4)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; TITLE TEXT ;;
(defun c:tt1 ()        
  (if (= nil v_text)
    (load "v_text")
  )
  (v_text "h" 1)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:tt2 ()
  (if (= nil v_text)
    (load "v_text")
  )
  (v_text "h" 2)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:tt3 ()
  (if (= nil v_text)
    (load "v_text")
  )
  (v_text "h" 3)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun c:tt4 ()
  (if (= nil v_text)
    (load "v_text")
  )
  (v_text "h" 4)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; UTILITY ;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; PURGE ALL ;;;;
(defun c:pall ()
  (cond
    ((/= (substr(getvar "PLATFORM") 1 4) "Micr")
      (setq mpgge nil)
      (if (= nil v_pur)
        (load "v_pur")
      )
      (v_pur)
    )
    ((and (>  (atoi (substr(getvar "ACADVER") 1 2)) 12)
          (= (substr(getvar "PLATFORM") 1 4) "Micr"))
      (if (= nil v_purwin)
        (load "v_purwin")
      )
      (v_purwin)
    )
    (T (prompt "\nCommand not supported by this Acad version/platform"))
  ) ; endc
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; HELP ;;;;;;;;;
(defun c:hv ()
  (if (<= (atoi (substr(getvar "ACADVER") 1 2)) 12)
    (acad_helpdlg "v_vhlp12.hlp" "")
    (help "v_vhlp13.ahp")
  )
)
(defun c:hs ()       ;; Softdesk commands
  (if (<= (atoi (substr(getvar "ACADVER") 1 2)) 12)
    (acad_helpdlg "v_shlp12.hlp" "")
    (help "v_shlp13.ahp")
  )
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; TIME CLOCK ;;;
(defun c:tc ()               ;; toggles elapsed
  (if (= nil togtc)          ;; edit timer
    (load "v_togtc")
  )
  (togtc)
  (princ)                     
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; REINITIALIZE 
(defun c:init ()
  (load "v_init")
  (v_init)
  (setq v_init nil)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; XREF ;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; AUTO X-WRITE 
(defun c:ax ()       
  (if (= nil autoxr)(progn
    (prompt "\nLoading ...")
    (load "v_xr1")
  ))
  (autoxr)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; X-FILE MANAGE
(defun c:ddx ()             
  (if (= nil vxrdd1)(progn  
    (prompt "\nLoading ...")
    (load "v_xr2")
  ))
  (vxrdd1)
  (princ)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
